unit fileFlag;

interface

uses
  {$IFDEF Win32}
  Windows, 
  {$ELSE}
  winProcs,
  {$ENDIF}
  Messages, 
  SysUtils, 
  Classes, 
  Graphics, 
  Controls, 
  Forms, 
  Dialogs,
  StdCtrls, 
  Buttons, 
  ExtCtrls, 
  NWServer, 
  Nwtools;

type
  TwinFileFlag = class(TForm)
    okBtn: TBitBtn;
    cancelBtn: TBitBtn;
    GroupBox1: TGroupBox;
    checkReadOnly: TCheckBox;
    checkShareable: TCheckBox;
    checkArchive: TCheckBox;
    checkHidden: TCheckBox;
    checkSystem: TCheckBox;
    checkExecute: TCheckBox;
    NWServer1: TNWServer;
    NWTools1: TNWTools;
    procedure okBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    fileFlags : TNWFileFlags ;
    fileName  : string ;
  end;

var
  winFileFlag: TwinFileFlag;

implementation

{$R *.DFM}

procedure TwinFileFlag.okBtnClick(Sender: TObject);
  begin
    if checkExecute.checked and 
      (not noYesBox('Attention! Vorsicht! Precauzione!;;' + 
                    'Execute-Only File Attribute Cannot Be Undone;;Are You Sure?')) then
      exit ;
    fillChar(fileFlags,sizeOf(fileFlags),false) ;
    with fileFlags do begin
      if ((not checkReadOnly.checked) and (not checkShareable.checked)) and
         ((not checkArchive.checked) and (not checkHidden.checked)) and
         ((not checkSystem.checked) and (not checkExecute.checked)) then
        normal := true 
      else
        begin
          readOnly     := checkReadOnly.checked ;
          shareable    := checkShareable.checked  ;
          needsArchive := checkArchive.checked  ;
          hidden       := checkHidden.checked  ;
          system       := checkSystem.checked  ;
          executeOnly  := checkExecute.checked  ;
        end;  
      if setFileFlags(0,fileName,fileFlags) then
        okBox(fileName + ';;Flagged Successfully')
      else
        alertBox(fileName + ';;Could Not Flag File;Check Access Rights and Try Again') ;  
    end;   
  end;

end.
 




